/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.lib.block.entity.ITileCallback;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StorageClearPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected int storageType;
    protected int storageIndex;

    public StorageClearPacket() {
        super(37, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof ITileCallback) {
            switch (StorageType.values()[this.storageType]) {
                case ENERGY: {
                    ((ITileCallback)tile).clearEnergy(this.storageIndex);
                    break;
                }
                case FLUID: {
                    ((ITileCallback)tile).clearTank(this.storageIndex);
                    break;
                }
                case ITEM: {
                    ((ITileCallback)tile).clearSlot(this.storageIndex);
                }
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.storageType);
        buf.writeInt(this.storageIndex);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.storageType = buf.readInt();
        this.storageIndex = buf.readInt();
    }

    public static boolean sendToServer(ITileCallback tile, StorageType storageType, int storageIndex) {
        if (tile == null) {
            return false;
        }
        StorageClearPacket packet = new StorageClearPacket();
        packet.pos = tile.pos();
        packet.storageType = storageType.ordinal();
        packet.storageIndex = storageIndex;
        packet.sendToServer();
        return true;
    }

    public static enum StorageType {
        ENERGY,
        FLUID,
        ITEM;

        public static final StorageType[] VALUES;

        static {
            VALUES = StorageType.values();
        }
    }
}

